const replaceHtmlText = (content) => {
    const {name,message,email} = content;
    return `<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Template</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .email-container {
            max-width: 600px;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .email-header {
            text-align: center;
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .email-body {
            font-size: 16px;
            line-height: 1.5;
            margin-bottom: 20px;
        }
        .email-footer {
            font-size: 14px;
            text-align: center;
            color: #888;
        }
    </style>
</head>
<body>

    <div class="email-container">
        <div class="email-header">
         ${name} From Portfolio ,
        </div>

        <div class="email-body">
            <p>${message}</p>
        </div>

        <div class="email-footer">
            <p>Please Response !ASAP🔥🔥 if this is important message</p>
            <p>Responder Email Here : ${email}</p>☻
        </div>
    </div>

</body>
</html>
`}

module.exports = replaceHtmlText