const express = require('express');
const nodemailer = require('nodemailer');
const cors = require('cors');
const { default: mustache } = require('mustache');
const { rateLimit } = require('express-rate-limit')
const axios  = require('axios')

require('dotenv').config();

const app = express();
const PORT = process.env.PORT || 5000;
const NOCODB_API_TOKEN = process.env.NOCODB_API_TOKEN
const NOCODB_BASE_URL = process.env.NOCODB_BASE_URL

const limiter = rateLimit({
	windowMs: 15 * 60 * 1000, // 15 minutes
	limit: 5, // Limit each IP to 100 requests per `window` (here, per 15 minutes).
	standardHeaders: 'draft-8', // draft-6: `RateLimit-*` headers; draft-7 & draft-8: combined `RateLimit` header
	legacyHeaders: false, // Disable the `X-RateLimit-*` headers.
	// store: ... , // Redis, Memcached, etc. See below.
})



// Middleware
app.use(cors({
    origin: ['http://localhost:5173','fnikolabs.com']
}));

app.use(express.json());

app.post('/get-data',async (req,res)=>{
    const {tablename, query} = req.body;
    const url = `${NOCODB_BASE_URL}/api/v2/tables/${tablename}/records?${query??""}`
    try {
        const response = await axios.get(url, {
          headers: {
            'xc-token': NOCODB_API_TOKEN,
          },
        });
        res.json(response.data);
      } catch (error) {
        console.error('Error fetching data from NocoDB:', error.message);
        console.log(url)
        res.status(500).send('Failed to fetch data from NocoDB.');
    }
})
// Email sending endpoint
app.post('/send-email', limiter ,async (req, res) => {
    const {email,  message, name } = req.body;
    const dest = process.env.EMAIL_DESTINATION||"fnikolas221@gmail.com"
    if (!email || !message || !name) {
        return res.status(400).json({ message: 'All fields are required' });
    }

    try {
        let transporter = nodemailer.createTransport({
            host: process.env.SMTP_HOST,
            port: process.env.SMTP_PORT,
            secure: process.env.SMTP_SECURE === 'true', // true for 465, false for other ports
            auth: {
                user: process.env.SMTP_USER,
                pass: process.env.SMTP_PASS
            }
        });

        const mail = {
            to: dest,
            from: process.env.SMTP_USER,
            subject: 'A Message From Portfolio by : '+name,
            html: mustache.to_html(template, { ...req.body })
          };
        transporter.sendMail(mail);

        res.status(200).json({ message: 'Email sent successfully', info });
    } catch (error) {
        res.status(500).json({ message: 'Error sending email', error });
    }
});


app.listen(PORT, () => {
    console.log(`Server is running on port ${PORT}`);
});
